#!/bin/sh

DPLY_PAGE_VERIFY_SETTINGS_RESULT_MSG=""
DPLY_PAGE_VERIFY_SETTINGS_RESULT_OK=0
DPLY_PAGE_VERIFY_SETTINGS_RESULT_ERROR=1

DPLY_PAGE_VERIFY_SETTINGS_RESULT_CODE=${DPLY_PAGE_VERIFY_SETTINGS_RESULT_ERROR}
DPLY_PAGE_VERIFY_SETTINGS_RESULT_ROLLING=0


dply_page_verify_settings() {
	debug_print "in function '${FUNCNAME[0]}'"
	
    ########################################
    # composing description
    ########################################
	local hidden_password=`echo "${RT_ESXI_PASSWORD}"| sed 's/^\(.*\)....$/\1\*\*\*\*/'`
	local desc="\
${DPLY_PAGE_VERIFY_SETTINGS_TEXT}\n\
\n\
ESXi Server Settings\n\
    ${STRING_USERNAME} ${RT_ESXI_USERNAME}\n\
    ${STRING_PASSWORD} ${hidden_password}\n\
Sandbox Controller Image\n\
    ${RT_SC_IMAGE_PATH}\n\
Custom Sandbox Image"

    local sb_img_count="`echo "${RT_SB_IMAGE_PATH_ESXI}" | sed 's/.vmx/\n/g' | wc -l`"
    local tmp="`echo "${RT_SB_IMAGE_PATH}" | sed 's/ /\n/g'`"
    local i
    for(( i=1; i<=$sb_img_count; i++ )); do
        desc="${desc}\n    `echo "${tmp}" | sed -n ${i}p`"
    done
    
    
    ########################################
    # bring out TextUI
    ########################################
	tp_yesno \
        "${DPLY_PAGE_VERIFY_SETTINGS_TITLE}" \
        "${desc}" \
        "${DPLY_PAGE_VERIFY_SETTINGS_LABEL_OK}" \
        "${DPLY_PAGE_VERIFY_SETTINGS_LABEL_CANCEL}"

    if [ "${TP_YESNO_RESULT_CODE}" == "${TP_YESNO_RESULT_ERROR}" ]; then
		DPLY_PAGE_VERIFY_SETTINGS_RESULT_CODE=$DPLY_PAGE_VERIFY_SETTINGS_RESULT_ERROR
		DPLY_PAGE_VERIFY_SETTINGS_RESULT_MSG=""
		DPLY_PAGE_VERIFY_SETTINGS_RESULT_ROLLING=0
        return
    fi
        
	case "${TP_YESNO_RESULT_SELECT}" in
		"${TP_YESNO_RESULT_YES}")
			;;
			
		"${TP_YESNO_RESULT_NO}")
			DPLY_PAGE_VERIFY_SETTINGS_RESULT_CODE=$DPLY_PAGE_VERIFY_SETTINGS_RESULT_OK
			DPLY_PAGE_VERIFY_SETTINGS_RESULT_MSG=""
			DPLY_PAGE_VERIFY_SETTINGS_RESULT_ROLLING=-1
            return
			;;
			
		*)
			DPLY_PAGE_VERIFY_SETTINGS_RESULT_CODE=$DPLY_PAGE_VERIFY_SETTINGS_RESULT_ERROR
			DPLY_PAGE_VERIFY_SETTINGS_RESULT_MSG=""
			DPLY_PAGE_VERIFY_SETTINGS_RESULT_ROLLING=0
            return
			;;
	esac

 
    ########################################
    # Preparation for deploying
    ########################################
    local i=1
    
    # write ESXi VM path related to NEW sandbox group to NewSBGroupInfoESXi
    # ex. /vmfs/volumes/<ds UID>/aaa/aaa.vmx
    local fpath="${NEW_SB_GROUP_INFO_ESXI_FILE}"
    [ -e "${fpath}" ] && rm -f "${fpath}"
    echo "`echo "${RT_SB_IMAGE_PATH_ESXI}" | sed 's/,/\n/g'`" > "${fpath}"
         
    
    # write VIX VM path related to NEW sandbox group to NewSBGroupInfoVIX
    # ex. [ha-datacenter/datastore1] aaa/aaa.vmx
    local fpath="${NEW_SB_GROUP_INFO_VIX_FILE}"
    [ -e "${fpath}" ] && rm -f "${fpath}"
    echo "`echo "${RT_SB_IMAGE_PATH_VIX}" | sed 's/,/\n/g'`" > "${fpath}"
    
    
    # write ESXi VM path related to ORIGINAL sandbox group to OriSBGroupInfoESXi
    # ex. /vmfs/volumes/<ds UID>/aaa/aaa.vmx
    local fpath="${ORIGIN_SB_GROUP_INFO_ESXI_FILE}"
    [ -e "${fpath}" ] && rm -f "${fpath}"
    touch "${fpath}"
         
    
    # write VIX VM path related to ORIGINAL sandbox group to OriSBGroupInfoVIX
    # ex. [ha-datacenter/datastore1] aaa/aaa.vmx
    local fpath="${ORIGIN_SB_GROUP_INFO_VIX_FILE}"
    [ -e "${fpath}" ] && rm -f "${fpath}"
    touch "${fpath}"


    # write ESXi VM path related to be REMOVED from NEW sandbox group to NewSBGroupToBeRemoved
    # ex. [ha-datacenter/datastore1] aaa/aaa.vmx
    local fpath="${NEW_SB_GROUP_TO_BE_REMOVED_FILE}"
    [ -e "${fpath}" ] && rm -f "${fpath}"
    touch "${fpath}"
    

    # write ESXi VM path related to be KEPT from NEW sandbox group to NewSBGroupToBeKept
    # ex. [ha-datacenter/datastore1] aaa/aaa.vmx
    local fpath="${NEW_SB_GROUP_TO_BE_KEPT_FILE}"
    [ -e "${fpath}" ] && rm -f "${fpath}"
    touch "${fpath}"
 

    # write ESXi VM path related to be added into NEW sandbox group to NewSBGroupToBeAdded
    # ex. [ha-datacenter/datastore1] aaa/aaa.vmx
    local fpath="${NEW_SB_GROUP_TO_BE_ADDED_FILE}"
    [ -e "${fpath}" ] && rm -f "${fpath}"
    echo "`echo "${RT_SB_IMAGE_PATH_ESXI}" | sed 's/,/\n/g'`" > "${fpath}"
    
	utility_save_sb_num_conf "${RT_SB_NUMBER}"
    if [ "${?}" -ne 0 ]; then
        DPLY_PAGE_VERIFY_SETTINGS_RESULT_CODE=$DPLY_PAGE_VERIFY_SETTINGS_RESULT_ERROR
        DPLY_PAGE_VERIFY_SETTINGS_RESULT_MSG="${UTILITY_SAVE_SB_NUM_CONF_RESULT_MSG}"
        DPLY_PAGE_VERIFY_SETTINGS_RESULT_ROLLING=0
        return
    fi

    # utility_save_multi_sb_image_path_conf \
        # "${RT_SB_IMAGE_PATH_ESXI}" \
        # "${RT_SB_IMAGE_PATH_VIX}"

    DPLY_PAGE_VERIFY_SETTINGS_RESULT_CODE=$DPLY_PAGE_VERIFY_SETTINGS_RESULT_OK
    DPLY_PAGE_VERIFY_SETTINGS_RESULT_MSG=""
    DPLY_PAGE_VERIFY_SETTINGS_RESULT_ROLLING=1
}
